<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */

require_once __DIR__ . '/vendor/autoload.php';
use Smalot\PdfParser\Parser;

$host = 'localhost';
$dbname = 'verificadordecomprovativos';
$username = 'root';
$password = '';

$message = '';
$modalMessage = '';
$isPositiveMessage = false;
$chaveStatus = '';

/* try { */
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Verificação de acesso por IP
    $ip = $_SERVER['REMOTE_ADDR'];
    $data_atual = date('Y-m-d H:i:s');
    
    $sql_verifica = "SELECT COUNT(*) as total FROM acessos 
                    WHERE ip = :ip AND 
                    TIMESTAMPDIFF(SECOND, dataRegistro, :data_atual) < 30";
    
    $stmt = $pdo->prepare($sql_verifica);
    $stmt->bindParam(':ip', $ip);
    $stmt->bindParam(':data_atual', $data_atual);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resultado['total'] == 0) {
        $sql_insere = "INSERT INTO acessos (ip, dataRegistro) VALUES (:ip, :data_atual)";
        $stmt = $pdo->prepare($sql_insere);
        $stmt->bindParam(':ip', $ip);
        $stmt->bindParam(':data_atual', $data_atual);
        $stmt->execute();
    }

    // Processamento do formulário
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Verificação da chave
        if (!empty($_POST['chave'])) {
            $chave = trim($_POST['chave']);
            
            $stmt = $pdo->prepare("SELECT * FROM chaves WHERE chave = :chave");
            $stmt->bindParam(':chave', $chave);
            $stmt->execute();
            $chave_info = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($chave_info) {
                if ($chave_info['dataInicio'] === null) {
                    $dataInicio = date('Y-m-d H:i:s');
                    $dataFim = date('Y-m-d H:i:s', strtotime('+7 days'));
                    
                    $stmt = $pdo->prepare("UPDATE chaves SET dataInicio = :dataInicio, dataFim = :dataFim WHERE chave = :chave");
                    $stmt->bindParam(':dataInicio', $dataInicio);
                    $stmt->bindParam(':dataFim', $dataFim);
                    $stmt->bindParam(':chave', $chave);
                    $stmt->execute();
                    
                    $chaveStatus = "Chave ativada! Válida até " . date('d/m/Y', strtotime($dataFim));
                    $isPositiveMessage = true;
                } else {
                    $dataAtual = new DateTime();
                    $dataFim = new DateTime($chave_info['dataFim']);
                    
                    if ($dataAtual > $dataFim) {
                        $chaveStatus = "Chave expirada em " . $dataFim->format('d/m/Y');
                        $isPositiveMessage = false;
                    } else {
                        $chaveStatus = "Chave válida até " . $dataFim->format('d/m/Y');
                        $isPositiveMessage = true;
                    }
                }
            } else {
                $chaveStatus = "Chave inválida!";
                $isPositiveMessage = false;
            }
            
            $modalMessage = $chaveStatus;
        }

        // Verificação do PDF
        if ($isPositiveMessage && isset($_FILES['pdfFile']) && $_FILES['pdfFile']['error'] == UPLOAD_ERR_OK) {
            $file = $_FILES['pdfFile']['tmp_name'];
            
            if (file_exists($file)) {
                try {
                    $parser = new Parser();
                    $pdf = $parser->parseFile($file);
                    $details = $pdf->getDetails();
                    $producer = $details['Producer'] ?? 'Não disponível';
                    
                    if ($producer === "iText® 7.0.5 ©2000-2017 iText Group NV (AGPL-version); modified using iText® 5.5.13.3 ©2000-2022 iText Group NV (AGPL-version)") {
                        $modalMessage .= "\nComprovativo verdadeiro (Multicaixa Express)";
                    } elseif ($producer === "iText® 5.5.13.3 ©2000-2022 iText Group NV (AGPL-version)") {
                        $modalMessage .= "\nComprovativo verdadeiro (Banco)";
                    } elseif ($producer === "iText 2.1.7 by 1T3XT") {
                        $modalMessage .= "\nComprovativo verdadeiro (Banco BIC)";
                    } elseif ($producer === "mPDF 7.1.9") {
                        $modalMessage .= "\nComprovativo verdadeiro (Banco BCI)";
                    } elseif ($producer === "Skia/PDF m133" || $producer === "iOS Version 17.5.1 (Build 21F90) Quartz PDFContext") {
                        $modalMessage .= "\nComprovativo verdadeiro (Banco BFA)";
                    } else {
                        $modalMessage .= "\nATENÇÃO: Documento não é de origem reconhecida";
                        $isPositiveMessage = false;
                    }
                } catch (Exception $e) {
                    $modalMessage .= "\nErro ao processar PDF: " . $e->getMessage();
                    $isPositiveMessage = false;
                }
            }
        } elseif (!$isPositiveMessage && isset($_FILES['pdfFile'])) {
            $modalMessage .= "\nVerificação do PDF não realizada - chave inválida ou expirada";
        }
    }
/* } catch (PDOException $e) {
    $modalMessage = "Erro no sistema: " . $e->getMessage();
    $isPositiveMessage = false;
} */
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <link rel="manifest" href="manifest.json">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificador de comprovativos</title>
    <style>
        /* Estilo básico para o botão de instalação */
        #installButton {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        #installButton:hover {
            background-color: #0056b3;
        }
        /* Estilo para fallback */
        .fallback-instructions {
            display: none;
            margin-top: 20px;
            font-size: 14px;
            color: #555;
        }
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 700px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            border: 10px solid rgba(30, 50, 70, 0.4);
        }
        h1 {
            text-align: center;
            color: #0056b3;
        }
        label {
            display: block;
            margin: 20px 0 10px;
            font-weight: bold;
        }
        input[type="file"] {
            padding: 5px;
            width: 100%;
        }
        button {
            margin-top: 20px;
            padding: 10px 20px;
            border: none;
            background-color: #0056b3;
            color: white;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #003d80;
        }
        .message {
            margin-top: 20px;
            padding: 10px;
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c8e6c9;
            border-radius: 4px;
        }
        .message.error {
            background: #ffebee;
            color: #c62828;
            border: 1px solid #ffcdd2;
        }
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
        }
        .modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            text-align: center;
        }
        .modal-content h2 {
            margin: 0 0 10px;
        }
        .modal-content p {
            font-size: 1.2em;
            margin: 10px 0;
        }
        .modal-icon {
            font-size: 3em;
            margin-top: 10px;
        }
        .modal-icon.positive {
            color: green;
        }
        .modal-icon.negative {
            color: red;
        }
        .modal-content button {
            margin-top: 10px;
            padding: 10px 20px;
            border: none;
            background-color: #0056b3;
            color: white;
            border-radius: 4px;
            cursor: pointer;
        }
        .modal-content button:hover {
            background-color: #003d80;
        }
        .sponsors {
            display: flex;
            justify-content: space-between;
            gap: 20px;
            margin: 30px 0;
        }
        .sponsor {
            flex: 1;
            padding: 20px;
            background: linear-gradient(135deg, #0056b3, #0099ff);
            border-radius: 12px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            color: #fff;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        .sponsor:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
        }
        .sponsor img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            margin-bottom: 10px;
            border: 2px solid #fff;
        }
        .sponsor p {
            margin: 10px 0 0;
            font-size: 1.1em;
            font-weight: bold;
        }
        .socials {
            margin-top: 40px;
            text-align: center;
        }
        .socials a {
            margin: 0 10px;
            text-decoration: none;
            display: inline-block;
        }
        .socials a img {
            width: 40px;
            height: 40px;
            transition: transform 0.3s;
        }
        .socials a img:hover {
            transform: scale(1.2);
        }
    </style>
    <style>
    /* Estilos existentes... */

    /* Media Queries para Responsividade */
    @media (max-width: 768px) {
        .container {
            margin: 20px auto;
            padding: 15px;
        }

        h1 {
            font-size: 1.5em;
        }

        .sponsors {
            flex-direction: column;
            gap: 10px;
        }

        .sponsor {
            padding: 15px;
        }

        .socials a img {
            width: 30px;
            height: 30px;
        }

        #installButton {
            bottom: 10px;
            right: 10px;
            padding: 8px 16px;
            font-size: 14px;
        }

        .modal-content {
            width: 90%;
            padding: 15px;
        }

        .modal-content h2 {
            font-size: 1.2em;
        }

        .modal-content p {
            font-size: 1em;
        }

        .modal-icon {
            font-size: 2em;
        }

        .modal-content button {
            padding: 8px 16px;
        }
    }

    @media (max-width: 480px) {
        .container {
            margin: 10px auto;
            padding: 10px;
        }

        h1 {
            font-size: 1.2em;
        }

        .sponsors {
            gap: 5px;
        }

        .sponsor {
            padding: 10px;
        }

        .socials a img {
            width: 25px;
            height: 25px;
        }

        #installButton {
            bottom: 5px;
            right: 5px;
            padding: 6px 12px;
            font-size: 12px;
        }

        .modal-content {
            width: 95%;
            padding: 10px;
        }

        .modal-content h2 {
            font-size: 1em;
        }

        .modal-content p {
            font-size: 0.9em;
        }

        .modal-icon {
            font-size: 1.5em;
        }

        .modal-content button {
            padding: 6px 12px;
        }
    }
</style>
</head>
<body style="background-color: #0056b3;">
    <div class="container">
        <button id="installButton">Instalar Aplicativo</button>
        <h1>Verificador de comprovativos</h1>
        <form method="post" enctype="multipart/form-data">
            <label for="chave">Chave de Ativação:</label>
            <input style="width: 100%; height: 25px; text-align: center; font-size: 18px;" type="text" name="chave" id="chave" placeholder="Digite sua chave" required>
            
            <ul>
                <li>Todos comprovativos gerados no <b style="color: orange;">Multicaixa Express</b></li>
                <li><b style="color: #0056b3;">BAI Directo</b></li>
                <li><b style="color: Red;">BIC Net</b></li>
                <li><b style="color: yellow;">SOL Net</b></li>
                <li><b style="color: orange;">BFA APP</b></li>
            </ul>
            
            <label for="pdfFile">Selecione um comprovativo em PDF:</label>
            <input type="file" name="pdfFile" id="pdfFile" accept="application/pdf" required>
            
            <button type="submit">Verificar</button>
            
            <?php if (!empty($modalMessage)): ?>
            <div class="message <?= $isPositiveMessage ? '' : 'error' ?>">
                <?= nl2br(htmlspecialchars($modalMessage)) ?>
            </div>
            <?php endif; ?>
            
            <div style="background-color: #fff; border-radius: 10px; padding: 25px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <h1 style="color: #2c3e50; font-size: 22px; margin-bottom: 15px; text-align: center;">Para continuar a utilizar o serviço, adquira já a sua chave válida por 1 semana por apenas 100 KZ!</h1>
        
        <div style="background-color: #f8f4e5; padding: 10px; border-radius: 5px; margin: 15px 0;">
            <strong>Como ativar:</strong>
        </div>
        
        <div style="margin: 20px 0;">
        <div style="margin-bottom: 15px; padding-left: 10px; border-left: 3px solid #25D366;">
            1️⃣ Transfira <strong>100 KZ</strong> para o IBAN: 
            <span style="font-weight: bold; color: #e74c3c;">0006.0000.8473.8976.3011.8</span>
            <button onclick="copyIban()" style="margin-left: 8px; padding: 4px 8px; background-color: #25D366; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 12px;">
                Copiar IBAN
            </button>
            <span id="copiedMsg" style="margin-left: 8px; color: #25D366; font-size: 12px; display: none;">IBAN copiado!</span>
        </div>

        <script>
        function copyIban() {
            const iban = "0006.0000.8473.8976.3011.8";
            navigator.clipboard.writeText(iban.replace(/\./g, '')).then(() => {
                const msgElement = document.getElementById('copiedMsg');
                msgElement.style.display = 'inline';
                setTimeout(() => {
                    msgElement.style.display = 'none';
                }, 2000);
            });
        }
        </script>
            
            <div style="margin-bottom: 15px; padding-left: 10px; border-left: 3px solid #25D366;">
                2️⃣ Envie o comprovativo para o nosso 
                <a href="https://wa.me/+244954748806" style="display: flex; align-items: center; gap: 8px; color: #25D366; text-decoration: none; font-weight: bold;" target="_blank">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp" style="width: 20px; height: 20px;">
                    WhatsApp
                </a>
            </div>
        </div>
        
        <p>Após a confirmação, sua chave será ativada e você poderá fazer verificações ilimitadas durante toda a semana!</p>
        
        <div style="margin-top: 20px; font-size: 14px; color: #7f8c8d; text-align: center;">
            <p>Dúvidas? Fale conosco! Estamos aqui para ajudar.</p>
        </div>
    </div>


            <div class="sponsors">
                <a href="https://smartschool.ao/index.php" target="_blank">
                    <div class="sponsor">
                        <img src="imgVerificador/367734362_6545594798890070_6416823727582877390_n.jpeg" alt="SmartSchool">
                        <p>SmartSchool</p>
                    </div>
                </a>
                <a href="https://www.facebook.com/marpinelda" target="_blank">
                    <div class="sponsor">
                        <img src="imgVerificador/7770575259_1730326590.jpeg" alt="Marpine">
                        <p>Marpine</p>
                    </div>
                </a>
                <a href="https://www.facebook.com/profile.php?id=61558964803134" target="_blank">
                    <div class="sponsor">
                        <img src="imgVerificador/7685236708_1730327160.20.44.jpeg" alt="Psicologia nas Comunidades">
                        <p>Psicologia nas Comunidades</p>
                    </div>
                </a>
            </div>
        </form>
        
        <div class="socials">
            <p>Nos siga nas redes sociais:<br>Paulo Sermão</p>
            <a href="https://web.facebook.com/paulo.sermao" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/733/733547.png" alt="Facebook">
            </a>
            <a href="https://www.instagram.com/paulo_sermao/" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/733/733558.png" alt="Instagram">
            </a>
            <a href="https://www.linkedin.com/in/paulo-serm%C3%A3o-2a96411b6/" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/733/733561.png" alt="LinkedIn">
            </a>
            <a href="https://www.tiktok.com/@paulosermaoo" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/3046/3046121.png" alt="TikTok">
            </a>
        </div>
    </div>

    <!-- Modal -->
    <div id="resultModal" class="modal" style="display: <?= !empty($modalMessage) ? 'flex' : 'none' ?>;">
        <div class="modal-content">
            <h2>Resultado da Verificação</h2>
            <p><?= nl2br(htmlspecialchars($modalMessage)) ?></p>
            <div class="modal-icon <?= $isPositiveMessage ? 'positive' : 'negative' ?>">
                <?= $isPositiveMessage ? '✔️' : '❌' ?>
            </div>
            <button onclick="closeModal()">Fechar</button>
        </div>
    </div>

    <script>
        // Funções do modal
        function showModal() {
            document.getElementById('resultModal').style.display = 'flex';
        }
        
        function closeModal() {
            document.getElementById('resultModal').style.display = 'none';
        }

        // PWA Installation
        let deferredPrompt;
        window.addEventListener('beforeinstallprompt', (e) => {
            e.preventDefault();
            deferredPrompt = e;
            document.getElementById('installButton').style.display = 'block';
        });

        document.getElementById('installButton').addEventListener('click', async () => {
            if (deferredPrompt) {
                deferredPrompt.prompt();
                const { outcome } = await deferredPrompt.userChoice;
                if (outcome === 'accepted') {
                    document.getElementById('installButton').style.display = 'none';
                }
            }
        });

        // Service Worker
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/service-worker.js')
                    .then(registration => {
                        console.log('ServiceWorker registrado com sucesso');
                    }).catch(err => {
                        console.log('ServiceWorker registro falhou: ', err);
                    });
            });
        }
    </script>
</body>
</html>